%-----------------------%
%   Read JSBACH Ouput   %
%-----------------------%

clc;                % Refresh Command Winforw
clear;              % clear Workspace
close all;          % close all Figures
format long g       % 14 decimal places
addpath(genpath('../Functions')) % load Functions
physicalConstants


humPlot  = true;
radPlot  = true;
resPlot  = true;
aeroPlot = true;




if(resPlot)


    x1 = (10:10:1000);
    
    r102 = load('./Input/varRes.1000SW.20RH.3Wind.mat');
    r142 = load('./Input/varRes.140SW.20RH.3Wind.mat');
    r148 = load('./Input/varRes.140SW.80RH.3Wind.mat');

    figure
    plot(x1,r102.t,'Color',newColor(2),'LineWidth',2)
    hold on
    plot(x1,r142.t,'Color',newColor(1),'LineWidth',2)
    plot(x1,r148.t,'Color',newColor(5),'LineWidth',2)
    
    xlabel('r_{s} [s/m]')
    ylabel('T_{eq} [°C]')
    set(gca,'FontSize',19)
    box off
    skipYTickLabel(gca,2)
    ax1 = gca;
    ax1.FontName = 'Verdana';

    
    
    yyaxis right
    
    plot(x1,r102.s,'Color',newColor(2),'LineWidth',1.5,'LineStyle','--')
    hold on
    plot(x1,r142.s,'Color',newColor(1),'LineWidth',1.5,'LineStyle','--')
    plot(x1,r148.s,'Color',newColor(5),'LineWidth',1.5,'LineStyle','--')

    ax2 = gca;
    ax2.YColor = 'k';
    %ax2.XLim = [0 1300];
    ax2.YLim = [-0.7 0];
    ax2.YTick = -0.7:0.1:0;
    ax2.FontName = 'Verdana';

    ylabel('Slope')
    skipXTickLabel(gca,2)
    skipYTickLabel(gca,1)
    
    
%     leg = legend(' 20% 1000W/m^2',...
%                  ' 20%   140W/m^2',...
%                  ' 80%   140W/m^2');
%     leg.Location = 'East';
%     leg.EdgeColor = 'none';
%     leg.FontSize = 19;

    drucken('./Output/Eq_res.png')
end


if(aeroPlot)

    x1 = (10:10:1000);
    
    a102 = load('./Input/varAero.1000SW.20RH.3Wind.mat');
    a108 = load('./Input/varAero.1000SW.80RH.3Wind.mat');
    a142 = load('./Input/varAero.140SW.20RH.3Wind.mat');
    a148 = load('./Input/varAero.140SW.80RH.3Wind.mat');
    a420 = load('./Input/varAero.400SW.20RH.3Wind.mat');
    a450 = load('./Input/varAero.400SW.50RH.3Wind.mat');
    a105 = load('./Input/varAero.1000SW.50RH.3Wind.mat');
    a145 = load('./Input/varAero.140SW.50RH.3Wind.mat');
    
    figure
    %plot(x1,a108.t,'Color',newColor(2),'LineWidth',2)
    plot(x1,a102.t,'Color',newColor(2),'LineWidth',2)
    hold on
    plot(x1,a142.t,'Color',newColor(1),'LineWidth',2)
    plot(x1,a148.t,'Color',newColor(5),'LineWidth',2) 
    %plot(x1,a145.t,'Color',newColor(5),'LineWidth',2)
    
    
    
    xlabel('r_{b} [s/m]')
    ylabel('T_{eq} [°C]')
    set(gca,'FontSize',19)
    box off
    skipYTickLabel(gca,2)
    ax1 = gca;
        ax1.FontName = 'Verdana';

    
    
    yyaxis right
    
    %plot(x1,a108.s,'Color',newColor(2),'LineWidth',1.5,'LineStyle','--')
    %plot(x1,a450.s,'Color',newColor(2),'LineWidth',1.5,'LineStyle','--')
    plot(x1,a102.s,'Color',newColor(2),'LineWidth',1.5,'LineStyle','--')
    hold on
    plot(x1,a142.s,'Color',newColor(1),'LineWidth',1.5,'LineStyle','--')
    plot(x1,a148.s,'Color',newColor(5),'LineWidth',1.5,'LineStyle','--');
    %plot(x1,a102.s,'Color',newColor(2),'LineWidth',1.5,'LineStyle','--')
    

    ax2 = gca;
    ax2.YColor = 'k';
    ax2.YLim = [-0.7 0];
    ax2.YTick = -0.7:0.1:0;
        ax2.FontName = 'Verdana';

    ylabel('Slope')
    skipXTickLabel(gca,2)
    skipYTickLabel(gca,1)
    
    
    leg = legend(' 20% 1000W/m^2',...
                 ' 20%   140W/m^2',...
                 ' 80%   140W/m^2');
    %leg = legend(' low RH, high S',...
    %             ' low RH, low S',...
    %             ' high RH, low S');
    leg.Location = 'East';
    leg.EdgeColor = 'none';
    leg.FontSize = 18;

    drucken('./Output/Eq_aero.png')
end



if(humPlot)
    x1 = 0:0.01:1;
    x1(end) = NaN;
    h1000 = load('./Input/varHum.1000SW.3Wind.mat');
    h140 = load('./Input/varHum.140SW.3Wind.mat');

    figure
    plot(x1,h1000.t,'Color',newColor(2),'LineWidth',2)
    hold on
    plot(x1,h140.t,'Color',newColor(1),'LineWidth',2)
    
    xlabel('RH')
    ylabel('T_{eq} [°C]')
    set(gca,'FontSize',19)
    box off
    skipYTickLabel(gca,2)
    ax1 = gca;
        ax1.FontName = 'Verdana';

    
    
    yyaxis right
    
    plot(x1,h1000.s,'Color',newColor(2),'LineWidth',1.5,'LineStyle','--')
    hold on
    plot(x1,h140.s,'Color',newColor(1),'LineWidth',1.5,'LineStyle','--')

    ax2 = gca;
    ax2.YColor = 'k';
    %ax2.XLim = [0 1300];
    ax2.YLim = [-0.35 0];
        ax2.FontName = 'Verdana';

    ylabel('Slope')
    skipXTickLabel(gca,2)
    skipYTickLabel(gca,1)
    
    
    leg = legend(' S_{in} = 1000 W/m^2',' S_{in} = 140 W/m^2');
    leg.Location = 'Northwest';
    leg.EdgeColor = 'none';
    leg.FontSize = 19;

    drucken('./Output/Eq_hum.png')

end

if(radPlot)
    load('./Input/RH50.Wind03.mat') %3
    r80 = load('./Input/varRad.80RH.3Wind.mat');
    r20 = load('./Input/varRad.20RH.3Wind.mat');

    figure
    plot(x1,r80.t,'Color',newColor(2),'LineWidth',2)
    hold on
    plot(x1,r20.t,'Color',newColor(1),'LineWidth',2)
    
    xlabel('S_{in} [W/m^2]')
    ylabel('T_{eq} [°C]')
    set(gca,'FontSize',19)
    box off
    skipYTickLabel(gca,2)
    ax1 = gca;
        ax1.FontName = 'Verdana';

    
    
    yyaxis right
    
    plot(x1,r80.s,'Color',newColor(2),'LineWidth',1.5,'LineStyle','--')
    hold on
    plot(x1,r20.s,'Color',newColor(1),'LineWidth',1.5,'LineStyle','--')

    ax2 = gca;
    ax2.YColor = 'k';
    ax2.XLim = [0 1300];
    ax2.XTick = [0:200:1200];
    ax2.YLim = [-0.35 0];
    ax2.YTick = -0.35:0.05:0;
        ax2.FontName = 'Verdana';

    ylabel('Slope')
    skipXTickLabel(gca,2)
    skipYTickLabel(gca,1)
    
    
    leg = legend(' RH = 80%',' RH = 20%');
    leg.Location = 'South';
    leg.EdgeColor = 'none';
    leg.FontSize = 19;

    drucken('./Output/Eq_rad.png')

end


