% General Settings %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clc;                % Refresh Command Window
clear
close all;          % close all Figures
format long g       % 14 decimal places
% time units (in seconds)
sec = 1; minute = 60*sec; hour = 60*minute; day = 24*hour; y = 365*day;

addpath(genpath('../Functions')) % Load functions

physicalConstants


inputFolder   = '/Users/Marvin/Desktop/Work/CEBA/experiments';




outName = 'ref_LTfalse.ref_LTtrue';
mask='maskCEBa';
cosAvail = true;

%%% Clas %%%

clasFolder='CEBa3h';
outClas='outdata_20200826_CEBa_ref_LTfalse';
expClas='CEBa3h';

clasPath = [inputFolder '/' clasFolder '/' outClas '/jsbach'];
clasFile = [expClas '.GPP.1979-2008.' mask '.hourly.Apr-Sep.nc'];
[~, ~, clas] = readNetcdf([clasPath '/' clasFile]);






%%% CEBa %%%

cebaFolder='CEBa3h';
outCEBa='outdata_20191104_finalThesis';
expCEBa='CEBa3h';

cebaPath = [inputFolder '/' cebaFolder '/' outCEBa '/jsbach'];
cebaFile = [expCEBa '.GPP.1979-2008.' mask '.hourly.Apr-Sep.nc'];
[~, ~, ceba] = readNetcdf([cebaPath '/' cebaFile]);


  


    clasNPP  = clas.net_assimilation;
    clasGPP  = clas.gross_assimilation;
    if(cosAvail)
        clasCosz = clas.cos_zenith;
    else
        clasCosz = ones(size(clas.gross_assimilation));
    end
    
    
    cebaNPP  = ceba.net_assimilation;
    cebaGPP  = ceba.gross_assimilation;
    cebaCosz = ceba.cos_zenith;
    Time     = ceba.time;

    nanIdx = clasNPP < -9999 | clasGPP < -9999 | clasCosz < -9999 | cebaNPP < -9999 | cebaGPP < -9999 | cebaCosz < -9999;

    cebaNPP(nanIdx) = NaN;
    cebaGPP(nanIdx) = NaN;
    cebaCosz(nanIdx) = NaN;
    clasNPP(nanIdx) = NaN;
    clasGPP(nanIdx) = NaN;
    clasCosz(nanIdx) = NaN;

    lnpp = reshape(clasNPP,[],1);
    lgpp = reshape(clasGPP,[],1);
    lCo = reshape(clasCosz,[],1);
    
    cnpp = reshape(cebaNPP,[],1);
    cgpp = reshape(cebaGPP,[],1);
    cCo = reshape(cebaCosz,[],1);

    cnpp = cnpp(~isnan(cnpp));
    cgpp = cgpp(~isnan(cgpp));
    cCo = cCo(~isnan(cCo));
    
    lnpp = lnpp(~isnan(lnpp));
    lgpp = lgpp(~isnan(lgpp));
    lCo = lCo(~isnan(lCo));



outFile = [outName '.GPP.1979-2008.' mask '.Apr-Sep.mat'];
save(['./Output/' outFile],'cnpp','cgpp','cCo','lnpp','lgpp','lCo')





