#!/bin/bash



rm log.txt>/dev/null 2>> log.txt



mainPath=/work/mh0020/m300483/CEBA/experiments

readData=true

expFolder=rs0CEBa3h
outFolder=outdata_20200820_CEBa_ws1
currExp=rs0CEBa3h

mask=maskCEBa

# 49 Tcan
# 50 Tgrd
# 75 tair
# 87 cosz
# 107 lai
# 139 tsurf/tcas

outdataPath=${mainPath}/${expFolder}/${outFolder}>/dev/null 2>> log.txt
codeFile=${outdataPath}/log/*land.codes>/dev/null 2>> log.txt
outputFile=${outdataPath}/jsbach/${currExp}.1979-2008.grb
# -ymonmean -yearmean
if [ $readData == true ] ; then
	echo "Read data..."
	#25,49,75,81,82,83,107
	cdo -s -select,code=81,83 ${outdataPath}/jsbach/${expFolder}_jsbach_land_{1979..2008}.grb ${outputFile}>/dev/null 2>> log.txt
	cdo -s -setctomiss,0 -mul -selcode,83 ${outputFile} ${mask}.nc ${outdataPath}/jsbach/${currExp}.Tcan.grb>/dev/null 2>> log.txt
	cdo -s -setctomiss,0 -mul -selcode,81 ${outputFile} ${mask}.nc ${outdataPath}/jsbach/${currExp}.Tair.grb>/dev/null 2>> log.txt
	cdo -s -t ${codeFile} -f nc copy  -selmon,4,5,6,7,8,9 -sub ${outdataPath}/jsbach/${currExp}.Tcan.grb ${outdataPath}/jsbach/${currExp}.Tair.grb ${outdataPath}/jsbach/${currExp}.1979-2008.${mask}.Apr-Sep.Tcan-Tair.monMean.nc>/dev/null 2>> log.txt
	cdo -s -t ${codeFile} -f nc copy  -selmon,4,5,6,7,8,9 -setctomiss,0 -mul ${outputFile} ${mask}.nc ${outdataPath}/jsbach/${currExp}.1979-2008.${mask}.Apr-Sep.monMean.nc>/dev/null 2>> log.txt

fi
