%----------------------------%
%   Process siteCEBa Ouput   %
%----------------------------%

clc;                % Refresh Command Window
clear;              % clear Workspace
close all;          % close all Figures
format long g       % 14 decimal places
addpath(genpath('../Functions')) % Load functions
physicalConstants

expID = 'rs0CEBa3h';
mask = 'maskCEBa';


inPath = './Input/';


[~, ~, var] = readNetcdf([inPath expID '.1979-2008.' mask '.Apr-Sep.nc']);
[~, ~, diff] = readNetcdf([inPath expID '.1979-2008.' mask '.Apr-Sep.Tcan-Tair.nc']);



Tair = var.dayTair;
delT = diff.dayTcan;
nanIdx = Tair<-9999 | delT<-9999;
Tair(nanIdx) = NaN;
delT(nanIdx) = NaN;

Ta = reshape(Tair,[],1)-T0;
dT = reshape(delT,[],1);

Ta = Ta(~isnan(Ta));
dT = dT(~isnan(dT));

figure
hold on
scatter(Ta,dT,'MarkerEdgeColor',newColor(1),'MarkerEdgeAlpha',0.8,'LineWidth',1)

xx = length(dT);
fit1a = fit(Ta,dT,'a*x+b','StartPoint',[1 0]);


expID = 'CEBa3h';

mask = 'maskCEBa';

inPath = './Input/';


[~, ~, var] = readNetcdf([inPath expID '.1979-2008.' mask '.Apr-Sep.nc']);
[~, ~, diff] = readNetcdf([inPath expID '.1979-2008.' mask '.Apr-Sep.Tcan-Tair.nc']);



Tair = var.dayTair;
delT = diff.dayTcan;
nanIdx = Tair<-9999 | delT<-9999;
Tair(nanIdx) = NaN;
delT(nanIdx) = NaN;

Ta = reshape(Tair,[],1)-T0;
dT = reshape(delT,[],1);

Ta = Ta(~isnan(Ta));
dT = dT(~isnan(dT));
fit1b = fit(Ta,dT,'a*x+b','StartPoint',[1 0]);
yy = length(dT);

scatter(Ta,dT,'MarkerEdgeColor',newColor(2),'MarkerEdgeAlpha',0.5,'LineWidth',1)
ax = gca;
ax.FontName = 'Verdana';
ax.FontSize = 22;
ax.XLim = [-10 40];
ax.YLim = [-1 9];
ax.XTick = -10:5:40;
ax.YTick = -1:9;

p = plot(-15:40,zeros(1,56),'Color','k','LineWidth',1.5);
p.Color(4) = 0.3;



line1a  = plot([-20 40],[-20*fit1a.a+fit1a.b 40*fit1a.a+fit1a.b]);
line1a.Color = newColor(1);
line1a.LineStyle = '--';
line1a.LineWidth = 1.5;

line1b  = plot([-20 40],[-20*fit1b.a+fit1b.b 40*fit1b.a+fit1b.b]);
line1b.Color = newColor(2);
line1b.LineStyle = '--';
line1b.LineWidth = 1.5;

str1a = functionLabel(fit1a.a,fit1a.b);
str1b = functionLabel(fit1b.a,fit1b.b);

leg = legend([line1b line1a],[' stressed:    ' str1b], [' unstressed: ' str1a]);
leg.Location = 'Northwest';
leg.EdgeColor = 'none';
leg.FontSize = 20;
legend boxoff

skipXTickLabel(gca,2)
skipYTickLabel(gca,1)

xlabel(['T_{air} [' char(176) 'C]'])
ylabel(['T_{leaf} ' char(8211) ' T_{air} [K]'])

offsetAxesOrig(gca,2,2)
drucken('./Plots/globPlot.png')



function funcStr = functionLabel(aParam,bParam,numDig)
    if nargin > 2
        strOpt = ['%1.' num2str(numDig) 'f'];
    else
        strOpt = '%1.2f';
    end

    if aParam > 0
        aStr = ['  ' num2str(abs(aParam),strOpt)];
    else
        aStr = [char(8211) num2str(abs(aParam),strOpt)];
    end

    if bParam > 0
        bStr = ['+ ' num2str(abs(bParam),strOpt)];
    else
        bStr = [char(8211) ' ' num2str(abs(bParam),strOpt)];
    end

    funcStr = ['f(x) = ' aStr 'x ' bStr];
end


function y = obsReg(x)

    y = -0.27.*x+7.83;
end


