function [qsatNew,esat] = qsatNew(T,p) % Temperature (K) pressure (Pa) 
 % ----------------------------------------------------------------------
% ----------------------------------------------------------------------
% This function calculates the saturation specific humidity for liquid
% water as a function of temperature and pressure, it is based on the
% polynomial fits of Flatau et al., (JAM 31:1507), it is written in F90
%
eps = 0.622;
c0  = 0.6105851e+03;
c1  = 0.4440316e+02;
c2  = 0.1430341e+01;
c3  = 0.2641412e-01;
c4  = 0.2995057e-03;
c5  = 0.2031998e-05;
c6  = 0.6936113e-08;
c7  = 0.2564861e-11;
c8  =-0.3704404e-13;

T0       = 273.16;
T        = T-T0;
if sum(T<-80) > 0
    %warning('Temperature out of range (lower than 80 degC)!')
elseif sum(T>100) > 0
    %warning('Temperature out of range (higher than 100 degC)!')
end
T(T<-80) = -80;
T(T>100) = 100;
esat     = c0+T.*(c1+T.*(c2+T.*(c3+T.*(c4+T.*(c5+T.*(c6+T.*(c7+T.*c8)))))));
qsatNew  = eps*esat./(p-(1.-eps).*esat);
 

end