%   % Natural constants
%   % -----------------
%   %
  m = 60; hr = 60*m; d = 24*hr; yr = 365*d;

  
moist_wilt_fract	= 0.35;
moist_crit_fract    = 0.75;
cvdifts = 1.5;
%   % WMO/SI values
%   avo   = 6.02214179E+23; %> [1/mo]    Avogadro constant
%   ak    = 1.3806504E-23; % [J/K]     Boltzmann constant
%   argas = 8.314472;      % [J/K/mol] molar/universal/ideal gas constant
  stbo  = 5.6704E-08;     % [W/m2/K4] Stephan-Boltzmann constant
%   %
%   %> Molar weights
%   % -------------
%   %
%   % Pure species
%   amco2 = 44.0095;       %>[g/mol] CO2 (National Institute for
%                                                   %  Standards and Technology (NIST))
%   amch4 = 16.043;        % [g/mol] CH4
%   amo3  = 47.9982;       % [g/mol] O3
%   amo2  = 31.9988;       % [g/mol] O2
%   amn2o = 44.013;        % [g/mol] N2O
%   amc11 =137.3686;       % [g/mol] CFC11
%   amc12 =120.9140;       % [g/mol] CFC12
%   amw   = 18.0154;       % [g/mol] H2O
%   %
%   %> Mixed species
%   amd   = 28.970;        %> [g/mol] dry air
%   %
%   %> Auxiliary constants
%   % ppmv2gg converts ozone from volume mixing ratio in ppmv
%   % to mass mixing ratio in g/g
%   ppmv2gg=1.E-06*amo3/amd;
%   %
%   %> Earth and Earth orbit constants
%   % -------------------------------
%   %
%   earth_radius           = 6.371229e6;    % [m]    average radius
%   inverse_earth_radius   = 1./earth_radius;         % [1/m]
%   %earth_angular_velocity = 7.29212E-05;    % [rad/s]  angular velocity
%   %                       read from namelist runctl, is saved in mo_control (for RCE)
%   %
%   % WMO/SI value
  grav  = 9.80665;       %> [m/s2] av. gravitational acceleration
%   rgrav = 1./grav;       % [s2/m]
%   %
%   rae   = 0.1277E-02;     %> [m/m]  ratio of atm. scale height
%   %                                               %        to Earth radius
%   secperday = 86400.;    % seconds per day
%   %
%   %> Thermodynamic constants for the dry and moist atmosphere
%   % --------------------------------------------------------
%   %
%   %> Dry air
  rd    = 287.04;        %> [J/K/kg] gas constant
  cpd   = 1004.64;       % [J/K/kg] specific heat at constant pressure
  cvd   = cpd-rd;           % [J/K/kg] specific heat at constant volume
%   con_m = 1.50E-05;       % [m^2/s]  kinematic viscosity of dry air
%   con_h = 2.20E-05;       % [m^2/s]  scalar conductivity of dry air
%   con0_h= 2.40E-02;       % [J/m/s/K]thermal conductivity of dry air
%   eta0d = 1.717E-05;      % [N*s/m2] dyn viscosity of dry air at tmelt
%   %
%   %> H2O
%   % - gas
  rv    = 461.51;        %> [J/K/kg] gas constant for water vapor
  cpv   = 1869.46;       % [J/K/kg] specific heat at constant pressure
  rgas  = 8.314472;      % [J/K/mol] molar/universal/ideal gas constant

%   cvv   = cpv-rv;           % [J/K/kg] specific heat at constant volume
%   dv0   = 2.22E-05;       % [m^2/s]  diff coeff of H2O vapor in dry air at tmelt
%   %> - liquid / water
%   rhoh2o= 1000.;         %> [kg/m3]  density of liquid water
%   %> H2O related constants  (liquid, ice, snow), phase change constants
%   % echam values
%   rhosea = 1025.0;        % density of sea water in kg/m3
%   rhoice = 917.0;         % density of ice in kg/m3
%   rhosno = 300.0;         % density of snow in kg/m3
%   rhoiw  = rhoice/rhoh2o;    % density ratio (ice/water)
%   cpliq  = 4218.;         % specific heat for liquid water J/K/kg
%   cpsea  = 3994.;         % specific heat for sea water J/K/kg
%   cpice  = 2106.;         % specific heat for ice J/K/kg
%   cpsno  = 2090.;         % specific heat for snow J/K/kg
%   alice  = 2.1656;        % thermal conductivity of ice in W/K/m
%   Lsubno  = 0.31;          % thermal conductivity of snow in W/K/m
%   % echam values end
%   %
clw   = 4186.84;       % [J/K/kg] specific heat of water
%   %                                                  %  see below 
%   cv_i =  2000.0;
%   %> - phase changes
  Lv   = 2.5008e6;      %> [J/kg]   latent heat for vaporisation
  Lsub   = 2.8345e6;      % [J/kg]   latent heat for sublimation
%   alf   = Lsub-Lv;          % [J/kg]   latent heat for fusion
  T0 = 273.15;        % [K]      melting temperature of ice/snow
%   %
%   %> Auxiliary constants
  rdv   = rd/rv;            %> [ ]
%   % the next 2 values not as parameters due to ECHAM-dyn
vtmpc1= rv/rd-1.0;      % [ ]
vtmpc2= cpv/cpd-1.0;    % [ ]
%   rcpv  = cpd/cpv-1.0;    % [ ]
%   Lvdcp= Lv/cpd;          % [K]
%   Lsubdcp= Lsub/cpd;          % [K]
%   rcpd  = 1.0/cpd;        % [K*kg/J]
%   rcvd  = 1.0/cvd;        % [K*kg/J]
%   rcpl  =  3.1733;       % cp_d / cp_l - 1
%   %
%   clw   = (rcpl + 1.0) * cpd; %> specific heat capacity of liquid water
%   cv_v  = (rcpv + 1.0) * cpd - rv;
%   %
%   O_m_rdv  = 1.-rd/rv;   %> [ ]
%   rd_o_cpd = rd/cpd;        % [ ]
%   cvd_o_rd = cvd/rd;        % [ ]
%   %
%   p0ref     = 100000.0;   %> [Pa]  reference pressure for Exner function
%   %> Auxiliary constants used in ECHAM
%   % Constants used for computation of saturation mixing ratio
%   % over liquid water (*c_les*) or ice(*c_ies*)
%   c1es  = 610.78;           %
%   c2es  = c1es*rd/rv;          %
%   c3les = 17.269;           %
%   c3ies = 21.875;           %
%   c4les = 35.86;            %
%   c4ies = 7.66;             %
%   %
%   %> Variables for computing cloud cover in RH scheme
%    uc1  = 0.8;
%    ucl  = 1.00;
%   %
%   %> vertical profile parameters (vpp) of CH4 and N2O
%   vpp_ch4 = [1.25E-01  683.0 -1.43];
%   vpp_n2o = [1.20E-02 1395.0 -1.43];
%   %
%   %> constants for radiation module
  emiss = 0.996;  %> lw sfc default emissivity factor
%   %
%   %---------------------------
%   % Specifications, thresholds, and derived constants for the following subroutines:
%   % s_lake, s_licetemp, s_sicetemp, meltpond, meltpond_ice, update_albedo_ice_meltpond
%   %
%   dmix     = 10.0;   % mixed-layer depth of lakes in m
%   %dmixsea  = 50.0;   % mixed-layer depth of ocean in m
%   %       read from namelist runctl as rmlo_depth, is saved in mo_control
%   dice     = 0.05;   % minimum ice thickness in m
%   dicepond = 0.01;   % minimum ice thickness of pond ice in m
%   dicelim  = 0.10;   % threshold ice thickness for pond closing in m
%   dpondmin = 0.01;   % minimum pond depth for pond fraction in m
%   albpondi = 0.30;   % albedo of pond ice
%   %
%   snicecond = alice/Lsubno * rhoh2o/rhosno;
%   hcapmix   = rhoh2o*cpliq*dmix;     % heat capacity of lake mixed layer 
%   %                                                         %  in J/K/m2
%   hcapice   = rhoice*cpice*dice;     % heat capacity of upper ice layer
%   hcapicep  = rhoice*cpice*dicepond; % heat capacity of upper pond ice layer
%   %
%   rhoilf    = rhoice*alf;           % [J/m3]
%   rhowlf    = rhoh2o*alf;           % [J/m3]
%   hcaprilf  = hcapmix/rhoilf;        % [m/K]
%   rilfhcap  = rhoilf/hcapmix;        % [K/m]
%   tfreez    = dice*rilfhcap;         % cooling below tmelt required to form dice
%   %---------------------------
%   %
%   %------------below are parameters for ocean model---------------
%   % coefficients in linear EOS
%   a_T = 2.55E-04;        % thermal expansion coefficient (kg/m3/K)
%   b_S = 7.64E-01;        % haline contraction coefficient (kg/m3/psu)
%   %
%   % density reference values, to be constant in Boussinesq ocean models
%   rho_ref = 1025.022;         % reference density [kg/m^3]
%   rho_inv = 0.0009755881663;  % inverse reference density [m^3/kg]
%   sal_ref = 35.0;             % reference salinity [psu]
%   %
%   SItodBar = 1.0E-04;          %Conversion from pressure [p] to pressure [bar]
%   %                                                    %used in ocean thermodynamics
%   sfc_press_pascal = 101300.0;
%   sfc_press_bar    = 101300.0*SItodBar;
%   %
   p0 = 101325.;  % [Pa]     sea level pressure
   S0 =  1361.371;
%   %
%   %----------below are parameters for sea-ice model---------------
%   ks      =    0.31;   % heat conductivity snow     [J  / (m s K)]
%   ki      =    2.03;   % heat conductivity ice      [J  / (m s K)]   
%   rhoi    =  910.0;    % density of sea ice         [kg / m3]
%   rhos    =  330.0;    % density of snow            [kg / m3]
%   ci      = 2100.0;    % Heat capacity of ice       [J / (kg K)]
%   Tf      =   -1.80;   % Temperature ice bottom     [C]
%   Sice    =    5.0;    % Sea-ice bulk salinity      [ppt]
%   mu      =    0.054;  % Constant in linear freezing-
%   %                                             % point relationship         [C/ppt]
%   muS     =  mu*Sice;     % = - (sea-ice liquidus 
%   %                                             % (aka melting) temperature) [C]
%   %muS = -(-0.0575 + 1.710523E-03*Sqrt(Sice) - 2.154996E-04*Sice) * Sice
%   albs    =    0.75;   % Albedo of snow (not melting)
%   albsm   =    0.65;   % Albedo of snow (melting)    
%   albi    =    0.66;   % Albedo of ice (not melting)
%   albim   =    0.64;   % Albedo of ice (melting)    
%   albedoW =    0.1;    % albedo of the ocean 
%   %I_0     =    0.3       % Ice-surface penetrating shortwave fraction
%   I_0     =    0.0;    % Ice-surface penetrating shortwave fraction  % Natural constants



%-- 1.1 Constants for *vdiff*

  %clam = 150;
  ckap = 0.4;
  cb = 5;
  cc = 5;
  %cd = 5;
  %cchar = 0.018;
  %cfreec = 0.001;
  %cgam = 1.25;
  %cvdifts = 1.5;
  
  