function  outData = pdfFit(inData)  

    pdf_normmixture = @(x,p,mu1,mu2,sigma1,sigma2) ...
                         p*normpdf(x,mu1,sigma1) + (1-p)*normpdf(x,mu2,sigma2);
    pStart = 0.5;
    muStart = quantile(inData,[.25 .75]);
    sigmaStart = sqrt(var(inData) - .25*diff(muStart).^2);
    start = [pStart muStart sigmaStart sigmaStart];
    
    lb = [0 -Inf -Inf 0 0];
    ub = [1 Inf Inf Inf Inf];
    
    statset('mlecustom');
    
    options = statset('MaxIter',300, 'MaxFunEvals',600);
    paramEsts = mle(inData, 'pdf',pdf_normmixture, 'start',start, ...
                          'lower',lb, 'upper',ub, 'options',options);
    outData = pdf_normmixture(inData,paramEsts(1),paramEsts(2),paramEsts(3),paramEsts(4),paramEsts(5));
    
    
end