function [yTicks,yMin,yMax,yInt,ynInt] = niceYTicks(minVal,maxVal,nInt)

if nargin<3, nInt = 8; end

% difference between highest and lowest value
diff   = abs(maxVal - minVal);

% order of magnitude
mag = fix(log10(diff));
% if mag < 0
%     error('Dynamic computation of y-ticks is unsupporter for magnitudes lower than 1.')
% end
% magnitude
mag10 = 10^mag;
%diffVal = ceil(diffVal/mag10)*mag10;  <-- this statement has to be tested yet

% possible interval sizes
posInt = repmat([0.25 0.5 1 2 5]',2,1);  % an interval step contains only 1, 2 or 5 (and multiplies of ten)
posInt(1:3)   = posInt(1:3)   * mag10/10;   % one lower magnitude
posInt(4:end) = posInt(4:end) * mag10;

% find number of intervals close to nInt
[~,minPos] = min(abs(diff./posInt - nInt));

yInt   = posInt(minPos);
yMin   = floor(minVal/yInt)*yInt;
yMax   = ceil(maxVal/yInt)*yInt;
ynInt  = abs(yMax-yMin)/yInt;
yTicks = yMin:yInt:yMax;

end