function labelStr = linearFitLabel(fit,numberOfDigits)
    if nargin > 1
        strOpt = ['%1.' num2str(numberOfDigits) 'f'];
    else
        strOpt = '%1.2f';
    end
    
    fitData = coeffvalues(fit);
    fitNum  = length(fitData);
    
    
    
    labelStr = ' f(x) =';
    for i = 1:fitNum
        
        if(i==fitNum-1)
            var = 'x';
        elseif(i==fitNum)
            var = '';
        else
            var = ['x^{' num2str(fitNum-i) '}'];
        end
        
        
        if(fitData(i)>=0 && i==1)
            sign = ' ';
        elseif(fitData(i)>=0)
            sign = '+ ';
        elseif(fitData(i)<0 && i==1)
            sign = char(8211);
        else
            sign = [char(8211) ' '];
        end
        labelStr = [labelStr ' ' sign num2str(abs(fitData(i)),strOpt) var];
    end
end
