function drucken(path)
% Print Preview
suffix = path(end-2:end);
set(gcf,'Units','Points');
if(ismember(suffix,'pdf'))
    set(gcf, 'PaperOrientation', 'landscape');
else
    set(gcf, 'PaperOrientation', 'portrait');
end
    
size = get(gcf,'Position');
size = size(3:4); % the last two elements are width and height of the figure
set(gcf,'PaperUnit','points'); % unit for the property PaperSize
set(gcf,'PaperSize',size);

% Print
if(ismember(suffix,'pdf'))
    print(['-d' suffix],path)
else
   print(['-d' suffix],'-r200',path)
end
end


