%------------------------------------------%
%   Read, process, and write netcdf-file   %
%------------------------------------------%

clc;                % Refresh Command Window
clear;              % clear Workspace
close all;          % close all Figures
format long g       % 14 decimal places
addpath(genpath('~/Dropbox/Hiwi/Functions')) % Load functions



%-------------------%
%   User settings   %
%-------------------%

inputFolder  = '~/Desktop/Work/JSB_OFFLINE/SurfaceFile/';
outputFolder = '~/Desktop/Work/JSB_OFFLINE/SurfaceFile/';

%inputFolder  = './';
%outputFolder = '/Users/Marvin/Desktop/bmm/SurfaceFile/';

inputFile    = 'jsbach_8-21_11tiles_5layers_1976.nc';
outputFile   = 'jsbach_8-21_01tiles_5layers_1976_100vegratio_pft5_50sfc_50rd_40alb.nc';




%----------------------%
%   Read netcdf-file   %
%----------------------%

[glo, dim, var] = readNetcdf([inputFolder inputFile]);

dim.Num           = dim.Num+1;
dim.Name{dim.Num} = 'lct';
dim.Len(dim.Num)  = 21;
dim.lct           = 21;

%-------------------------%
%   Process netcdf-file   % 
%-------------------------%
var.lat            = 50.9624;
var.lon            = 13.5652;
var.elevation      = 385;

% var.ntiles      = [1 2 3]';
% dim.ntiles      = 3;
% dim.Len(3)      = 3;
% 
% var.cover_fract = ones(1,1,dim.ntiles);
% var.cover_type  = ones(1,1,dim.ntiles);
% var.natural_veg = ones(1,1,dim.ntiles);
% 
% var.cover_fract(1,1,:) = [0.067 0.233 0.7];
% var.cover_type(1,1,:)  = [15 16 20];
% var.natural_veg(1,1,:) = [1e-10 1e-10 1e-10];

var.ntiles      = 1;
dim.ntiles      = 1;
dim.Len(3)      = 1;

var.cover_fract = 1;
var.cover_type  = 5;
var.natural_veg = 1;

var.veg_ratio_max = 1;

for i=1:size(var.veg_fract,3)
    var.veg_fract(:,:,i) = 1;
end

a = 0.4;
var.albedo          = a*var.albedo;
var.albedo_soil_nir = a*var.albedo_soil_nir;
var.albedo_soil_vis = a*var.albedo_soil_vis;
var.albedo_veg_nir  = a*var.albedo_veg_nir;
var.albedo_veg_vis  = a*var.albedo_veg_vis;

var.root_depth     = 0.5*var.root_depth;
var.soil_field_cap = 0.5*var.soil_field_cap;




%var.root_depth     = var.soillev(2);


var.maxmoist = var.root_depth * var.soil_field_cap; 



%-----------------------%
%   Write netcdf-file   % 
%-----------------------%

writeNetcdf([outputFolder outputFile], glo, dim, var)

%copyfile(outputFile,'~/Desktop/Work/JSB_OFFLINE/SurfaceFile/')
%copyfile([outputFolder outputFile],'~/Desktop/Scratch/mpiesm_20180201_Offline_Paper/mpiesm-landveg/experiments/Trop_Ref/input/jsbach/')
%copyfile([outputFolder outputFile],'~/Desktop/Scratch/mpiesm_20180216_Off_Skin/mpiesm-landveg/experiments/Trop_Skin/input/jsbach/')












    
    

