% General Settings %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clc;                % Refresh command window
clear;              % Clear all variables
close all;          % Close all figures
format long g       % 14 decimal places
sec = 1; m = 60*sec; h = 60*m; d = 24*h; y = 365*d;      % time units (in seconds)
addpath(genpath('../../../Functions')) % load Functions



%-------------------%
%   Read jsb-file   %
%-------------------%
jsbInputFolder  = './';
jsbInputFile    = 'climate_wfdei-gpcc_T63_oneTimeStep_1990.nc';

[jsb.glo, jsb.dim, jsb.var] = readNetcdf([jsbInputFolder jsbInputFile]);


lat = jsb.var.lat;
lon = jsb.var.lon;

% Dice
%tropLat = 37.7;
%tropLon = 263.2;

% Fluxnet Tropics
%tropLon = 305.0285;
%tropLat = -3.018;

% Fluxnet Tharandt
tropLon = 13.5652;
tropLat = 50.9624;


[LonVal,LonPos] = min(abs(lon-tropLon));
[LatVal,LatPos] = min(abs(lat-tropLat));


disp(['Lat Pos: x = ' num2str(LonPos) ' (' num2str(lon(LonPos)) ')'])
disp(['Lon Pos: y = ' num2str(LatPos) ' (' num2str(lat(LatPos)) ')'])




