%----------------------------%
%   Process siteCEBa Ouput   %
%----------------------------%

clc;                % Refresh Command Window
clear;              % clear Workspace
close all;          % close all Figures
format long g       % 14 decimal places

onMac       = true;
siteName    = 'trop';             % choose between trop thar and dice
surfScheme  = 'CEBa';
expID       = 'Ref';
hourMean    = true;


if(onMac)
    addpath(genpath('~/Dropbox/Hiwi/Functions')) % Load functions
else
    addpath(genpath('/home/mpim/m300483/Functions')) % Load functions
end
physicalConstants


if(onMac)
    inputFolder   = '/Users/Marvin/Desktop/Work/CEBA/experiments/';
else
    inputFolder   = '/work/mh0020/m300483/CEBA/experiments/';
end

switch siteName
    case 'trop'
        siteFolder  = 'siteCEBa/outdata/Tropics/'; 
    case 'thar'
        siteFolder  = 'siteCEBa/outdata/Tharandt/';
    case 'glob'
        siteFolder  = 'rs0CEBa3h/outdata/timestep_data/';
    case 'dice'
        siteFolder  = 'siteCEBa/outdata/DICE/';
    otherwise
        error('Site not avaiblable!')
end

inputFolder = [inputFolder siteFolder]; 
inputFile   = [siteName '.' surfScheme '.' expID '.raw.mat'];

disp('Load raw data...')
load([inputFolder inputFile])

disp('Process raw data...')
startDate = datestr(raw.Time(1));
finalDate = datestr(raw.Time(end));

if(hourMean)
    meanName = {'Year'   'Quarter'   'Month'   'Week'   'Day'   'Hour'  };
    meanly   = {'yearly' 'quarterly' 'monthly' 'weekly' 'daily' 'hourly'}; 
else
    meanName = {'Year'   'Quarter'   'Month'   'Week'   'Day'  };
    meanly   = {'yearly' 'quarterly' 'monthly' 'weekly' 'daily'}; 
end


for iMean = 1:length(meanly)
    proc.(meanName{iMean}) = retime(raw, meanly{iMean}, 'mean');
end


[proc.Cyc, proc.Std] = diuCycleTimeTable(raw,startDate,finalDate);

disp('Save processed data...')
if(hourMean)
save([inputFolder inputFile(1:end-8) '.hour.proc.mat'],'proc')
else
save([inputFolder inputFile(1:end-8) '.proc.mat'],'proc')   
end


