%----------------------------%
%   Process siteCEBa Ouput   %
%----------------------------%

clc;                % Refresh Command Window
clear;              % clear Workspace
close all;          % close all Figures
format long g       % 14 decimal places

siteName    = 'thar';             % choose between trop thar and dice
surfScheme  = 'ObsNew';
hourMean    = true;


addpath(genpath('../../Functions')) % Load functions
physicalConstants




inputFolder   = './Output/';
inputFile   = [siteName '.' surfScheme '.raw.mat'];

disp('Load raw data...')
load([inputFolder inputFile])

disp('Process raw data...')
startDate = datestr(raw.Time(1));
finalDate = datestr(raw.Time(end));

if(hourMean)
    meanName = {'Year'   'Quarter'   'Month'   'Week'   'Day'   'Hour'  };
    meanly   = {'yearly' 'quarterly' 'monthly' 'weekly' 'daily' 'hourly'}; 
else
    meanName = {'Year'   'Quarter'   'Month'   'Week'   'Day'  };
    meanly   = {'yearly' 'quarterly' 'monthly' 'weekly' 'daily'}; 
end


for iMean = 1:length(meanly)
    proc.(meanName{iMean}) = retime(raw, meanly{iMean}, 'mean');
end


[proc.Cyc, proc.Std] = diuCycleTimeTable(raw,startDate,finalDate);

disp('Save processed data...')
save([inputFolder inputFile(1:end-8) '.proc.mat'],'proc')


