# -*- coding: utf-8 -*-
"""
Created on Mon Sep 08 15:22:58 2014

@author: s4493222
"""
'''
Code to support SI for 
Reconciling the signal and noise of atmospheric warming on decadal timescales
Roger N Jones* and James H Ricketts

Victoria Institute of Strategic Economic Studies, Victoria University, Melbourne, Victoria 8001, Australia
Correspondence to: Roger N. Jones (roger.jones@vu.edu.au)

And related publications

This code made available for informational purposes under the Creative Commons Attribution 3.0 License (enabling electronic and paper copies);
'''
import numpy as np
import bivariate_multi as bivariate
import scipy.stats as stats
import STARS
import ConvergentBreaks as convergent_breaks
import random
import whitening
import datetime
import copy
SVNRevision="$Revision: 286 $"

def shuffle_stat(xs1, ys1, Years, pos, iterations=100):
  '''
  recompute Ti0 and breakpoint locations by reanalysing the values on each side of the breaks point
  xs are control
  ys are test
  pos is the location being tested
  iterations is the number of times to test  
  '''
  #MUST take copies of input because the shuffles have side effects. JHR 13/10/2014
  if len(xs1) == 0:
    print "oops"
  xs=copy.copy(xs1)
  ys=copy.copy(ys1)  
  index=range(len(xs))
  TiList = []
  TiPosIndex=[]
  ShiftList=[]
  pos = min(pos, len(index))
  for i in range(iterations):
    lowx=xs[:pos+1]
    lowy=ys[:pos+1]
    hix=xs[pos+1:]
    hiy=ys[pos+1:]
    np.random.shuffle(lowx)
    np.random.shuffle(lowy)
    np.random.shuffle(hix)
    np.random.shuffle(hiy)
    lowx = np.append(lowx, hix)
    lowy = np.append(lowy, hiy)
    bv=bivariate.bivariate(lowy, lowx, anomalise=False, constantsxy=True)
    try:
      TiList.append(bv.maxTi())
      TiPosIndex.append(Years[bv.maxIndexTi()])
      ShiftList.append(bv.stepChange())
    except Exception as e:
      print str(e)
      raise
  return TiPosIndex, TiList,ShiftList
  

def shuffle_cut(xs, ys, Years, pos, iterations=100):
  '''
  recompute Ti0 and breakpoint locations by reanalysing the values on each side of the breaks point
  xs are control
  ys are test
  pos is the location being tested
  iterations is the number of times to test  
  '''
  
  TiPosIndex, TiList,ShiftList=shuffle_stat(xs, ys, Years, pos, iterations=iterations)
  bins=np.bincount(TiPosIndex)
  mode=bins.argmax()
  return stats.norm.fit(TiPosIndex), stats.norm.fit(TiList),stats.norm.fit(ShiftList), float(bins[mode])/iterations, mode, 
  
def shuffle_mode(xs, ys, Years, pos, iterations=100):
  '''
  recompute Ti0 and breakpoint locations by reanalysing the values on each side of the breaks point
  xs are control
  ys are test
  pos is the location being tested
  iterations is the number of times to test  
  '''
  
  TiPosIndex, TiList,ShiftList=shuffle_stat(xs, ys, Years, pos, iterations=iterations)
  bins=np.bincount(TiPosIndex)
  mode=bins.argmax()
  return bins[mode], mode


  
if __name__ == "__main__":
  '''
  Test code goes here
  '''
