# -*- coding: utf-8 -*-
"""
Created on Tue Jan 13 19:19:18 2015

@author: s4493222
"""
'''
Code to support SI for 
Reconciling the signal and noise of atmospheric warming on decadal timescales
Roger N Jones* and James H Ricketts

Victoria Institute of Strategic Economic Studies, Victoria University, Melbourne, Victoria 8001, Australia
Correspondence to: Roger N. Jones (roger.jones@vu.edu.au)

And related publications

This code made available for informational purposes under the Creative Commons Attribution 3.0 License (enabling electronic and paper copies);
'''

#ICMP file reader -Sample data Monthly across columns year in first column
#Data obtained from KNMI Climate Explorer http://climexp.knmi.nl/selectfield_cmip5.cgi?id=someone@somewhere 
'''
# using minimal fraction of valid points 30.00
# tas [Celsius] from CanESM2 model output prepared for CMIP5 pre-industrial control r1i1p1
# cutting out region lon=    0.000  360.000, lat=  -90.000   90.000
 1001   11.83417       11.97769       12.79282       13.82053       14.79425       15.36234       15.67563       15.43896       14.71530       13.64081       12.55502       11.97772    
 1002   11.70071       12.13474       13.00824       13.79724       14.67404       15.60947       15.99591       15.64621       14.89542       13.78076       12.92712       12.24026    
 ...
'''
import numpy as np
class ICMP(object):
  def __init__(self, fn):
    with open(fn,"r") as f:
      lines = f.readlines()
    self.__filename = fn
    self.__header=lines[:3]
    self.__data=[]
    for line in lines[3:]:
      self.__data.append(np.array(line.split(),dtype=float))
    self.__data=np.array(self.__data)
    #print np.shape(self.__data)

  def data(self):
    return self.__data
    
  def monthly(self):
    return self.__data[:,1:]
    
  def annual_means(self):
    return np.mean(self.monthly(),axis=1)

  def monthly_means(self):
    return np.mean(self.monthly(),axis=0)

  def annual_sums(self):
    return np.sum(self.monthly(),axis=1)

  def monthly_sums(self):
    return np.sum(self.monthly(),axis=0)

  def years(self):
    return self.__data[:,0]
 
  def filename(self):
    return self.__filename
if __name__ == "__main__":
   #your test case here
  icmp=ICMP('PATHTOFILE')

