# -*- coding: utf-8 -*-
"""
Created on Wed Jan 14 13:41:14 2015

@author: s4493222
"""
'''
Code to support SI for 
Reconciling the signal and noise of atmospheric warming on decadal timescales
Roger N Jones* and James H Ricketts

Victoria Institute of Strategic Economic Studies, Victoria University, Melbourne, Victoria 8001, Australia
Correspondence to: Roger N. Jones (roger.jones@vu.edu.au)

And related publications

This code made available for informational purposes under the Creative Commons Attribution 3.0 License (enabling electronic and paper copies);
'''

import numpy as np
#HADCRUT file reader
#http://www.metoffice.gov.uk/hadobs/hadcrut4/data/current/series_format.html

#==============================================================================
# These 'best estimate' series are computed as the medians of regional time series computed for each of the 100 ensemble member realisations. Time series are presented as temperature anomalies (deg C) relative to 1961-1990.
# 
# Quoted uncertainties are computed by integrating across the distribution described by the 100 ensemble members, together with additional measurement and sampling error and coverage uncertainty information.
# 
# The data files contain 12 columns:
# 
#     Column 1 is the date.
#     Column 2 is the median of the 100 ensemble member time series.
#     Columns 3 and 4 are the lower and upper bounds of the 95% confidence interval of bias uncertainty computed from the 100 member ensemble.
#     Columns 5 and 6 are the lower and upper bounds of the 95% confidence interval of measurement and sampling uncertainties around the ensemble median. These are the combination of fully uncorrelated measurement and sampling uncertainties and partially correlated uncertainties described by the HadCRUT4 error covariance matrices.
#     Columns 7 and 8 are the lower and upper bounds of the 95% confidence interval of coverage uncertainties around the ensemble median.
#     Columns 9 and 10 are the lower and upper bounds of the 95% confidence interval of the combination of measurement and sampling and bias uncertainties.
#     Columns 11 and 12 are the lower and upper bounds of the 95% confidence interval of the combined effects of all the uncertainties described in the HadCRUT4 error model (measurement and sampling, bias and coverage uncertainties).
#==============================================================================

class HADCRUT4(object):
  def __init__(self, filename, annual=True):
    with open(filename, 'r') as f:
      self.__filename = filename
      lines=f.readlines()
      self.__data = []
      for line in lines:
        self.__data.append(np.array(line.split(), dtype=float))
      self.__data = np.array(self.__data)
    
  def data(self):
    return self.__data
    
  def annual(self):
    return self.__data[:,1]
    
  def years(self):
    return self.__data[:,0]
 
  def filename(self):
    return self.__filename
