# -*- coding: utf-8 -*-
"""
Created on Mon Sep 29 12:02:29 2014

@author: s4493222
"""
'''
Code to support SI for 
Reconciling the signal and noise of atmospheric warming on decadal timescales
Roger N Jones* and James H Ricketts

Victoria Institute of Strategic Economic Studies, Victoria University, Melbourne, Victoria 8001, Australia
Correspondence to: Roger N. Jones (roger.jones@vu.edu.au)

And related publications

This code made available for informational purposes under the Creative Commons Attribution 3.0 License (enabling electronic and paper copies);
'''

#CMIP5.py reads in CMIP5 data for processing
import numpy as np
from CMIP3 import CMIP3gw
import sys
'''
File format looks as below (no headers, and comma separators)
1871,  287.812
'''
SVNRevision="$Revision: 286 $"
class CMIP5Exception(Exception):
  def __init__(self, msg):
    self.__msg="CMIP5Exeption:"+str(msg)
  def __str__(self):
    return str(self.__msg)
    
class CMIP5gw(CMIP3gw):
  def __init__(self, filenameList):
    super(CMIP5gw,self).__init__(filenameList[0], sep=',')
    for filename in filenameList[1:]:
      super(CMIP5gw,self).appendFile(filename)


if __name__ == "__main__":
  fn="PATH\TO\FILE\GOES\HERE"
  print "Need to provide a file name and remove this halt"
  sys.exit()
  c3=CMIP5gw([fn])
  for i in range(c3.count()):
    print c3.Years()[i], c3.Temperature()[i], c3.Warming()[i]
  
  import convergent_breaks
  import random
  ys =  c3.Warming()
  xs = np.array([random.random() for y in ys])
  Years= c3.Years()
  cb=convergent_breaks.convergentBreaks(ys, xs, Years, 'GWAnom', mode="control", guide="Stability",screenpr=0.05, pr=0.01, trace=False)
  print cb
