# -*- coding: utf-8 -*-
"""
Created on Thu Jan 15 18:27:57 2015

@author: s4493222
"""
'''
Code to support SI for 
Reconciling the signal and noise of atmospheric warming on decadal timescales
Roger N Jones* and James H Ricketts

Victoria Institute of Strategic Economic Studies, Victoria University, Melbourne, Victoria 8001, Australia
Correspondence to: Roger N. Jones (roger.jones@vu.edu.au)

And related publications

This code made available for informational purposes under the Creative Commons Attribution 3.0 License (enabling electronic and paper copies);
'''

import numpy as np
class BERKLEY(object):
  def __init__(self, fn="C://Users//s4493222//Documents//ReferenceData//Berkley//Land_and_Ocean//Land_and_Ocean_summary.txt"):
    with open(fn,'r') as f:
      self.__filename=fn
      lines = f.readlines()
      self.__header=[]
      self.__data=[]
      i=0
      while len(lines[i]) == 0 or lines[i][0] in ["#","%"]:
        self.__header.append(lines[i])
        i+=1
        #print lines[i]
      for line in lines[i:]:
        if len(line)>3:self.__data.append(np.array(line.split(),dtype=float))
      self.__data=np.array(self.__data, dtype=float)
      
  def data(self):
    return self.__data
    
  def years(self):
    return self.__data[:,0] 
    
  def annual(self):
    return self.__data[:, 1]
 
  def filename(self):
    return self.__filename
    
if __name__ == "__main__":
  bd=BERKLEY()    
