#set working directory
setwd('C:/Climate/B13Comment')
library(TTR)


gfdl.rtmt.ts<-(-1)*ts(read.table("rtmt_Amon_GFDL-CM3_piControl.txt")[[2]], start=1, freq=12) #invert rtmt to get positive = outgoing flux
gfdl.tas.ts<-ts(read.table("tas_Amon_GFDL-CM3_piControl.txt")[[2]], start=1, freq=12)


#Find the lead lag coefficients and correlations between time series 
doLeadLag<-function(temp.ts, var.ts, monthTest=10)
{
	allLags<-numeric(monthTest+1)
	allCorrels<-numeric(monthTest+1)
	for (lagVal in 0:monthTest)
	{
		var.lagged.ts<-lag(var.ts, lagVal)
		test.lm<-lm(var.lagged.ts ~ temp.ts, data=ts.union(var.lagged.ts, temp.ts))
		allLags[lagVal+1]<-coef(test.lm)[2]	
		allCorrels[lagVal+1]<-summary(test.lm)$r.squared
	}
	list(allLags, allCorrels)	
}

#Run this for all start years 6-500
coefVals<-numeric(0)
startYrs<-numeric(0)
ratioVals<-numeric(0)
for (i in 1:494)
{
	startYr<-5+i
	endYr<-startYr+5
	rtmt<-SMA(window(gfdl.rtmt.ts, start=startYr, end=c(endYr,12)), n=12)
	rtmt<-rtmt-mean(rtmt, na.rm=TRUE)
	tas<-SMA(window(gfdl.tas.ts, start=startYr, end=c(endYr,12)), n=12)
	tas<-tas-mean(tas, na.rm=TRUE)

	lags<-doLeadLag(tas, rtmt)
	if (max(lags[[2]]) > 0.7)
	{	
		coefVals<-c(coefVals, lags[[1]][which(lags[[2]]==max(lags[[2]]))])
		startYrs<-c(startYrs,startYr)
		ratioVals<-c(ratioVals, (max(rtmt, na.rm=TRUE)/max(tas, na.rm=TRUE)+min(rtmt, na.rm=TRUE)/min(rtmt, na.rm=TRUE))/2)
	}
}

#example of lead/lag in GFDL CM3
startYr<-6 
endYr<-startYr+5
par(mar=c(5,5,5,5))
rtmt<-SMA(window(gfdl.rtmt.ts, start=startYr, end=c(endYr,12)), n=12)
rtmt<-rtmt-mean(rtmt, na.rm=TRUE)
tas<-SMA(window(gfdl.tas.ts, start=startYr, end=c(endYr,12)), n=12)
tas<-tas-mean(tas, na.rm=TRUE)
ts.plot(window(tas,start=startYr+1), col="blue", ylab=expression(Delta~T~'(K)'), main="GFDL-CM3 piCtrl")
par(new=TRUE)
plot(window(rtmt,start=startYr+1), axes="false", xlab="", ylab="", col="orange")
axis(4)
mtext("N (W/m^2)",side=4,line=3)
legend("topleft", legend=c("T", "N"), col=c("blue", "orange"), lty=1)

#figure 2
plot(density(coefVals), xlab=expression(alpha~'(W/m^2/K)'), main="GFDL-CM3 piCtrl"))
abline(v=0.75, col="red")



