#Troy Masters 2013
#This contains the script to draw the model averages and performs the adjustement to the temperature
# series using CMIP5 models

setwd('C:/Climate/Masters2013_ESD_Supplement')
source("MultipleRegressionHelpers.R")

par(mfrow=c(1,1))

#get averages for all ensembles
giss_e2_r.ts<-getModelAverage("GISS-E2-R", 1850)
giss_e2_h.ts<-getModelAverage("GISS-E2-H", 1850)
can_esm2.ts<-getModelAverage("CanESM2", 1850)
cnrm_cm5.ts<-getModelAverage("CNRM-CM5", 1850)
csiro.ts<-getModelAverage("CSIRO-Mk3-6-0", 1850)
ccsm4.ts<-getModelAverage("CCSM4", 1850)
hadGem2_es.ts<-getModelAverage("HadGEM2-ES", c(1859,12))

#plot them
ts.plot(giss_e2_r.ts, giss_e2_h.ts, can_esm2.ts, cnrm_cm5.ts, csiro.ts, ccsm4.ts,hadGem2_es.ts,col=rainbow(7),
	ylab=expression(Delta~T), ylim=c(-0.5, 0.3))
legend("bottomright", legend=c("GISS-E2-R", "GISS-E2-H", "CanESM2", "CNRM-CM5", "CSIRO-Mk3.6.0", 
	"CCSM4", "HadGEM2-ES", "Mean"), col=c(rainbow(7), "black"), lty=1)
abline(v=2000, col="gray")
mmm.ts<-(giss_e2_r.ts+giss_e2_h.ts+can_esm2.ts+cnrm_cm5.ts+csiro.ts+hadGem2_es.ts)/6
lines(mmm.ts, col="black", lwd=3)

	

#Now attempt reconstruction
source("MultipleRegressionHelpers.R")
nino34<-getNino34()
nino34.ts<-window(nino34, start=c(1954,9), end=c(2012,12))

giss.ts<-window(readGISS(), start=1979, end=c(2012,12))
hadCRUT4.ts<-window(getHadCRUT4(), start=1979, end=c(2012,12))
temp.ts<-hadCRUT4.ts#giss.ts

#remove using multi-model mean
residual_mmm.ts<-temp.ts-mmm.ts
ensoRem<-findENSOEffects(residual_mmm.ts,nino34.ts, 1979, c(2012,12), FALSE)
ensoRem2<-findENSOEffects(residual_mmm.ts,nino34.ts, 1979, c(2012,12), TRUE)
residual_mmmFinal.ts<-window(residual_mmm.ts - ensoRem2[['bestCoef']]*lag(nino34.ts, -1*ensoRem2[['bestLag']]), start=1979, end=c(2012,12))

#calculate which regression model (linear or quadratic) better represents the adjusted set
tm<-time(residual_mmmFinal.ts)
tm2<-tm^2
linear_mmm.lm<-lm(residual_mmmFinal.ts ~ tm)
print(paste("linear:", AIC(linear_mmm.lm)))
quad_mmm.lm<-lm(residual_mmmFinal.ts~ tm + tm2)
print(paste("quad:", AIC(quad_mmm.lm)))
print(paste("accel (K/dec^2):", 2*coef(quad_mmm.lm)[3]*10^2, 2*coef(summary(quad_mmm.lm))[3, "Std. Error"]*10^2))

#now half of multi-model mean
residual_mmmHalf.ts<-temp.ts-0.5*mmm.ts
ensoRem<-findENSOEffects(residual_mmmHalf.ts,nino34.ts, 1979, c(2012,12), FALSE)
ensoRem2<-findENSOEffects(residual_mmm.ts,nino34.ts, 1979, c(2012,12), TRUE)
residual_mmmHalfFinal.ts<-window(residual_mmmHalf.ts - ensoRem2[['bestCoef']]*lag(nino34.ts, -1*ensoRem2[['bestLag']]), start=1979, end=c(2012,12))


#calculate which regression model (linear or quadratic) better represents the adjusted set
tm<-time(residual_mmmHalfFinal.ts)
tm2<-tm^2
linear_mmmHalf.lm<-lm(residual_mmmHalfFinal.ts ~ tm)
print(paste("linear:", AIC(linear_mmmHalf.lm)))
quad_mmmHalf.lm<-lm(residual_mmmHalfFinal.ts~ tm + tm2)
print(paste("quad:", AIC(quad_mmmHalf.lm)))
print(paste("accel (K/dec^2):", 2*coef(quad_mmmHalf.lm)[3]*10^2, 2*coef(summary(quad_mmmHalf.lm))[3, "Std. Error"]*10^2))


#plot unadjusted and reconstructed
ts.plot(aggregate(temp.ts, nfreq=1)/12,  #unadjusted
	aggregate(residual_mmmFinal.ts, nfreq=1)/12, aggregate(ts(predict(quad_mmm.lm),start=1979, freq=12),nfreq=1)/12, #full adjusted
	aggregate(residual_mmmHalfFinal.ts, nfreq=1)/12, aggregate(ts(predict(quad_mmmHalf.lm),start=1979, freq=12),nfreq=1)/12, #half adjusted
	col=c("black", "red", "red", "blue", "blue"), ylab=expression(Delta~T~' (K)'), lty=c(1,1,2,1,2))

