#Troy Masters 2012
#Read ERA-Interim fluxes and perform global averages

#set working directory here
#must first install ncdf package
setwd("C:/Climate/Masters_2012/extra")

library(ncdf)

#########################
#FIRST READ ALL ERA-INTERIM DATA
###########################
era.nc<-open.ncdf("ECMWF_ERA_Interim_Fluxes.nc") #open our nc file

#function to perform global average for the variable specified

#first calc weights by area for each grid cell
weight.mat<-array(0,dim=c(240, 121))
for (x in 1:240)
{
	for (y in 1:121)
	{
		#Surface Area = R^2(lon1-lon2)(sin (lat1) - sin(lat2))
		lat1<-(90-(180/121)*(y-1))*pi/180
		lat2<-(90-(180/121)*(y))*pi/180
		weight.mat[x,y]<-(1.5)*pi/180*(sin(lat1) - sin(lat2))
	}
}
weight.mat<-weight.mat/(4*pi)

getEraGlobalAvgTs<-function(varName)
{
	var.avg<-numeric(142)
	for (totalMonth in 1:142)
	{
		var.cumm.month<-get.var.ncdf(era.nc, varName, start=c(1,1,1+2*(totalMonth -1)), count=c(240,121,2))
		var.month<-(var.cumm.month[,,1]+var.cumm.month[,,2])/(24*3600)
		var.avg[totalMonth]<-sum(var.month*weight.mat)	
	}
	var.ts<-ts(var.avg, start=c(2000,1), frequency=12)
}

sw_inc<-getEraGlobalAvgTs("tisr") #TOA incident solar radiation
sw_out_clr<-sw_inc-getEraGlobalAvgTs("tsrc") #Top net solar radiation, clear sky
lw_out_clr<-(-1) * getEraGlobalAvgTs("ttrc") #Top net thermal radiation, clear sky
sfc_solar<-getEraGlobalAvgTs("ssr") #Surface solar radiation
sfc_solar_down<-getEraGlobalAvgTs("ssrd") #Surface solar radiation downwards

#########################
#JOIN DATA TOGETHER AND PRINT
###########################
data<-ts.union(sw_inc, sw_out_clr, lw_out_clr, sfc_solar, sfc_solar_down) 
write.table(x=data, "C:/Climate/ERA-Interim/era_flux_data.txt")
