#Copyright 2012 Troy Masters
#Calculates the Ocean Heat Content of the top 100 meters based on 
#the globally averaged Ocean Temperatures by layer (outputs from COHCDataProcess.java required)

#Set your working directory here
setwd("C:/Climate/Masters_2012/Extra")

library(ncdf)

start<-c(2000,1)
end<-c(2010,4)

#Calculate the anomaly based on the yearly frequency
anom<-function(x, freq=12)
{
	totalSum<-numeric(freq)
	numObs<-numeric(freq)
	for (mon in 1:length(x))
	{
		totalSum[mon %% freq + 1]<-totalSum[mon %% freq + 1] + x[mon]
		numObs[mon %% freq + 1]<-numObs[mon %% freq + 1] + 1
	}
	anom<-numeric(length(x))
	for (mon in 1:length(x))
	{
		anom[mon]<-x[mon]-(totalSum[mon %% freq + 1]/numObs[mon %% freq + 1])	
	}	
	anom<-ts(anom,start=tsp(x)[1],freq=freq) 
}



####Now we try to determine the effective heat capacity
#values corresponding to the depths of the floats, along with the area at each depth

floatDepths<-read.table("depths.txt")[[1]]
depthAreas<-read.table("depthAreas.txt")[[1]]

layerBorders<-numeric(length(floatDepths)+1)
layerBorders[1]<-0
for (i in 2:length(floatDepths))
{
	layerBorders[i]<-(floatDepths[i-1]+floatDepths[i])/2	
}
layerBorders[length(layerBorders)]<-floatDepths[length(floatDepths)]

#function that will average the temperature from one depth to another (enter in m)
getTempToDepth<-function(depthStart, depthEnd, data)
{
	sum<-0*data[[2]]
	totalWeight<-0
	for (i in 1:16)
	{
		topBorder<-max(layerBorders[i], depthStart)
		btmBorder<-min(layerBorders[i+1], depthEnd)

		layerHeight<-0
		if (topBorder < btmBorder)
		{
			layerHeight<-btmBorder - topBorder
		}
		layerWeight<-layerHeight*depthAreas[i]	
		
		sum<-sum + layerWeight*data[[i]]	
		totalWeight<-totalWeight + layerWeight
	}
	print(totalWeight)
	return (sum / totalWeight) 
}

ohc.data<-read.table("NOAA_OceanTemps.txt",  header=TRUE)[2:17]
ohc.ml.ts<-ts(getTempToDepth(0, 100, ohc.data), start=c(1955,1), freq=4)
ohc.ml.anom<-anom(window(ohc.ml.ts,start=start,end=end), 4)

#heat capacity per m^3
Cw<-4*1000*1000 #J/K (4 J/g/K) * (1000 g/kg) * 1000 (kg/m^3)
ohc.top100.anom<-Cw*ohc.ml.anom*100 #J/m^2
df<-ts.union(time(ohc.top100.anom), ohc.top100.anom)
colnames(df)[1]<-"time"
colnames(df)[2]<-"Top 100m OHC (J/m^2)"
write.table(df, "Ocean_Heat_Content_Top100m.txt") 