#Troy Masters 2012

#set working directory here
#must first install ncdf package
setwd("C:/Climate/Masters_2012/extra")

library(ncdf)

#########################
#FIRST READ ALL ERA-INTERIM DATA 
# (download from http://data-portal.ecmwf.int/data/d/interim_moda/levtype=sfc/ the
# 2-metre temperature and skin temperature)
###########################
era_skt.nc<-open.ncdf("era_skt.nc") #open our nc file
era_t2m.nc<-open.ncdf("era_2m.nc") #open our nc file

#function to perform global average for the variable specified

#first calc weights by area for each grid cell
weight.mat<-array(0,dim=c(240, 121))
for (x in 1:240)
{
	for (y in 1:121)
	{
		#Surface Area = R^2(lon1-lon2)(sin (lat1) - sin(lat2))
		lat1<-(90-(180/121)*(y-1))*pi/180
		lat2<-(90-(180/121)*(y))*pi/180
		weight.mat[x,y]<-(1.5)*pi/180*(sin(lat1) - sin(lat2))
	}
}
weight.mat<-weight.mat/(4*pi)

getEraGlobalAvgTs<-function(ncFile, varName)
{
	var.avg<-numeric(142)
	for (totalMonth in 1:142)
	{
		var.month<-get.var.ncdf(ncFile, varName, start=c(1,1,totalMonth), count=c(240,121,1))
		var.avg[totalMonth]<-sum(var.month*weight.mat)	
	}
	var.ts<-ts(var.avg, start=c(2000,1), frequency=12)
}

skt.ts<-getEraGlobalAvgTs(era_skt.nc, "skt") #TOA incident solar radiation
t2m.ts<-getEraGlobalAvgTs(era_t2m.nc, "t2m") #TOA incident solar radiation

#########################
#JOIN DATA TOGETHER AND PRINT
###########################
data<-ts.union(time(t2m.ts), t2m.ts) 
write.table(x=data, "era_t2m.txt")

data<-ts.union(time(skt.ts), skt.ts) 
write.table(x=data, "era_skt.txt")