#calculations and graphs for the implicit prior paper

#feedback calculations

#library(plotrix)
#library(KernSmooth)

c_pri_scale <- 2.0


#likelihood parameters for lambda

l_o <- 2.3
l_sd <- 0.7

num <- 100000000

bww <- 0.05

#####
#####

#do calculation in sensitivity space with three priors

#uniform in lambda
#uniform in S
#Cauchy in S


l_ulp <- runif(num,min=0.37,max=10)
S_ulp <- 3.7/l_ulp

S_usp <- runif(num,min=0.37,max=10)
l_usp <- 3.7/S_usp

S_csp <- rcauchy(num,scale=5)
l_csp <- 3.7/S_csp

wt_ulp <- dnorm(l_ulp,mean=l_o,sd=l_sd)
wt_usp <- dnorm(l_usp,mean=l_o,sd=l_sd)
wt_csp <- dnorm(l_csp,mean=l_o,sd=l_sd)

wt_ulp <- wt_ulp/sum(wt_ulp)
wt_usp <- wt_usp/sum(wt_usp)
wt_csp <- wt_csp/sum(wt_csp)


pdf("fig5.pdf",width=10,height=10)

op <- par(cex.main = 1.5, mar = c(5, 6, 4, 5) + 0.1, mgp = c(3.5, 1, 0), cex.lab = 1.5,
    font.lab = 2, cex.axis = 1.3, bty = "n", las = 1)

plot(density(S_ulp,from = -0.,to=12.775,bw=bww),xlim=c(0,10),ylim=c(0,1.5),ty='n',lwd=3,col='magenta',lty=2,main="Priors and posteriors of S in analysis of interannual variability",xlab="Sensitivity",ylab="Density")

points(density(S_ulp,from = 0,to=12.775,bw=bww),xlim=c(0,10),ty='l',lwd=3,col='blue',lty=2)
points(density(S_ulp,weights=wt_ulp,from = 0,to=12.775,bw=bww),ty='l',lwd=10,col='cyan')
points(density(S_ulp,weights=wt_ulp,from = 0,to=12.775,bw=bww),ty='l',lwd=3,col='blue')

points(density(S_usp,from = 0,to=12.775,bw=bww),xlim=c(0,10),ty='l',lwd=3,col='red',lty=2)
points(density(S_usp,weights=wt_usp,from = 0,to=12.775,bw=bww),ty='l',lwd=3,col='red')

points(density(S_csp,from = 0,to=12.775,bw=bww),xlim=c(0,10),ty='l',lwd=3,col='magenta',lty=2)
points(density(S_csp,weights=wt_csp,from = 0,to=12.775,bw=bww),ty='l',lwd=3,col='magenta')


par(op)

dev.off()


d_ulp <- density(S_ulp,weights=wt_ulp,from = 0,to=12.775,bw=bww)
d_usp <- density(S_usp,weights=wt_usp,from = 0,to=12.775,bw=bww)
d_csp <- density(S_csp,weights=wt_csp,from = 0,to=12.775,bw=bww)

print(cbind(d_ulp$x,cumsum(d_ulp$y)/sum(d_ulp$y),cumsum(d_usp$y)/sum(d_usp$y),cumsum(d_csp$y)/sum(d_csp$y)))



