#pics and analysis for the historical section
#based on Thorsten method/numbers

library(plotrix)

nsamp <- 10000000

Q2_mn <- 0.71 #Johnson et al 2016
Q2_sd <- 0.10/1.645 #convert 5-95% to 1SD

Q1_mn <- 0.15 #Lewis and Currr 2014
Q1_sd <- 0.075

F_o = 2.158
F_sd = (3.133-1.183)/3.29

imbalance <- rnorm(nsamp,mean = Q2_mn-Q1_mn,sd = sqrt(Q2_sd^2+Q1_sd^2))
forcing <- rnorm(nsamp,mean = F_o,sd = F_sd)

bwid=0.05

#uniform DT prior and resulting posterior

dtemp_pri <-runif(nsamp,min=-1,max=10)

wt <- dnorm(0.771,mean=dtemp_pri,sd=0.08)

sensi_pri <- 3.71 * dtemp_pri /(forcing-imbalance)

pri<-density(sensi_pri,from=0,to=10,bw=bwid)

wt <- wt/max(wt)

rr <- runif(nsamp)

sensi_post <- sensi_pri[which(wt>rr)]

post <- density(sensi_post,from=0,to=10,bw=bwid)

so<-sort(sensi_post)
ll<-length(sensi_post)

print(c(so[ll/20],so[ll/2],so[ll*19/20]))

#uniform in sensi

sensi_pri <- runif(nsamp,min=0.371,max=10)
lambda_pri <- 3.71/sensi_pri

dt <- (forcing-imbalance)*sensi_pri/3.71

wt <- dnorm(0.771,mean=dt,sd=0.08)

wt <- wt/max(wt)
rr <- runif(nsamp)

po <- which(wt>rr)

pri_den <- density(sensi_pri,from=0,to=10,bw=bwid)
post_den <- density(sensi_pri[po],from=0,to=10,bw=bwid)

so<-sort(sensi_pri[po])
ll<-length(po)

print(c(so[ll/20],so[ll/2],so[ll*19/20]))

#uni in lambda

lambda_pri <- runif(nsamp,min=0.371,max=10)
sensi_pri <- 3.71/sensi_pri

dt <- (forcing-imbalance)*sensi_pri/3.71

wt <- dnorm(0.771,mean=dt,sd=0.08)

wt <- wt/max(wt)
rr <- runif(nsamp)

po <- which(wt>rr)

prilam_den <- density(sensi_pri,from=0,to=10,bw=bwid)
postlam_den <- density(sensi_pri[po],from=0,to=10,bw=bwid)

so<-sort(sensi_pri[po])
ll<-length(po)

print(c(so[ll/20],so[ll/2],so[ll*19/20]))

#cauchy in sensi

sensi_pri <- abs(rcauchy(nsamp,scale=5))
lambda_pri <- 3.71/sensi_pri

dt <- (forcing-imbalance)*sensi_pri/3.71

wt <- dnorm(0.771,mean=dt,sd=0.08)

wt <- wt/max(wt)
rr <- runif(nsamp)

po <- which(wt>rr)

pricau_den <- density(sensi_pri,from=0,to=10,bw=bwid)
postcau_den <- density(sensi_pri[po],from=0,to=10,bw=bwid)

so<-sort(sensi_pri[po])
ll<-length(po)

print(c(so[ll/20],so[ll/2],so[ll*19/20]))


pdf("fig4.pdf",width=10,height=10)

op <- par(cex.main = 1.5, mar = c(5, 6, 4, 5) + 0.1, mgp = c(3.5, 1, 0), cex.lab = 1.5,
    font.lab = 2, cex.axis = 1.3, bty = "n", las = 1)


plot(pri,ty='n',col='cyan',lwd=3,lty=2,main="Priors and posteriors for Bayesian estimate\n using 20th century data",xlab="Sensitivity",ylab="Density",ylim=c(0,1.5))

points(post,ty='l',col='cyan',lwd=10)

points(pri_den,ty='l',col='red',lwd=3,lty=2)
points(post_den,ty='l',col='red',lwd=3)

points(prilam_den,ty='l',col='blue',lwd=3,lty=2)
points(postlam_den,ty='l',col='blue',lwd=3)

points(pricau_den,ty='l',col='magenta',lwd=3,lty=2)
points(postcau_den,ty='l',col='magenta',lwd=3)


par(op)

dev.off()








