#calculations and graphs for the implicit prior paper

#20th century from thorsten paper

library(KernSmooth)


#numerical values for temp, forcing, imbalance at both ends of interval
DT_o <- 0.771
DT_sd <- 0.08

DF_o <- 2.158
DF_sd <- (3.133-1.183)/3.29

Q2_mn <- 0.71 #Johnson et al 2016
Q2_sd <- 0.10/1.645 #convert 5-95% to 1SD

Q1_mn <- 0.15 #Lewis and Currr 2014
Q1_sd <- 0.075

nsamp <- 10000000


#take a uniform prior in DT and a gaussian in F

DT <- runif(nsamp,min=-2,max=5)
DF <- rnorm(nsamp,mean=DF_o,sd=DF_sd)

imbalance <- rnorm(nsamp,mean = Q2_mn-Q1_mn,sd = sqrt(Q2_sd^2+Q1_sd^2))

S <- 3.71*DT/(DF-imbalance)
lambda <- 3.71/S

arr <- cbind(S,DF-imbalance)

arr2 <- arr[which((S>0.37) & (S<20)),]



out2 <- bkde2D(arr2,bandwidth=c(0.2,0.2),gridsize=c(126,61),range.x=list(c(0,25),c(0,6)))



pdf("fig3.pdf",width=10,height=10)

op <- par(cex.main = 1.5, mar = c(5, 6, 4, 5) + 0.1, mgp = c(3.5, 1, 0), cex.lab = 1.5,
    font.lab = 2, cex.axis = 1.3, bty = "n", las = 1)


contour(out2$x1,out2$x2,out2$fhat,axes=F,main = expression(paste("Joint and marginal densities for S and ",Delta,"F - ",Delta,"Q",sep="")))
axis(1, pos=0,at = c(0, 5, 10,15,20), lab = c("0", "5", "10", "15", "20"))
axis(2,pos=0,at=seq(0,4,by=1))
axis(3,pos=4.5,at=c(0,20),lwd.ticks=0,labels=F)
axis(4,pos=20.5,at=c(0,3),lwd.ticks=0,labels=F)
par(las = 0)
mtext("S", side = 1, line = 2.5, cex = 1.5, at = 5)
mtext(expression(paste(Delta,"F - ",Delta,"Q",sep="")), side = 2, line = 2.8, cex = 1.5,at=2)
#lines(c(1, ntime), c(0, 0), lwd = 1, lty = 2, col = "black")


so2<-sort(S[which((S>0.37) & (S<20))])

num2<-length(so2)

#percentiles
print(c(so2[num2*0.05],so2[num2/2],so2[num2*0.95]))


#now plot the marginals

rden<-density(arr2[,2],from=0,to=3,bw=0.1)
sden<-density(arr2[,1],bw=0.1)

scale<-20
lines(0.25*scale*rden$y+20.5,rden$x,lwd=3)
lines(sden$x,0.5*scale*sden$y+4.5,lwd=3)

segments(6,0,6,5.5,lwd=2,lty=2)
segments(0.6,0,0.6,5.5,lwd=2,lty=2)
segments(0,DF_o-Q2_mn+Q1_mn,24.5,DF_o-Q2_mn+Q1_mn,lwd=2,lty=2)

par(op)

dev.off()



