#calculations and graphs for the implicit prior paper

#paleo fig2

#needed for 2d kernel density estimate
library(KernSmooth)

#parameters of problem 

DT_o <- 5.
DT_sd <- 1.5

DF_o <- 9
DF_sd <- 2

num <- 100000000

#take a uniform prior in DT and a gaussian in F
#reparameterise into S and F

DT <- runif(num,min=0,max=20)
DF <- rnorm(num,mean=DF_o,sd=DF_sd)
S <- 3.7*DT/DF
lambda <- 3.7/S

arr <- cbind(S,DF)

#bound sensitivity to avoid extreme values
arr2 <- arr[which((S>0.37) & (S<20)),]

#2d kernel density estimate using KernSmooth package

out2 <- bkde2D(arr2,bandwidth=c(0.2,0.2),gridsize=c(221,131),range.x=list(c(0,22),c(4,17)))

pdf("fig2.pdf",width=10,height=10)

op <- par(cex.main = 1.5, mar = c(5, 6, 4, 5) + 0.1, mgp = c(3.5, 1, 0), cex.lab = 1.5,
    font.lab = 2, cex.axis = 1.3, bty = "n", las = 1)

contour(out2$x1,out2$x2,out2$fhat,axes=F,main = expression(paste("Joint and marginal densities for S and ",Delta,"F",sep="")))
axis(1, pos=4,at = c(0, 2, 4, 6, 8, 10,12,14,16), lab = c("0", "2", "4", "6", "8", "10","12","14","16"))
# NB the labels are divided by 10 because dt = .1
axis(2,pos=0,at=seq(4,14,by=2))
axis(3,pos=14.5,at=c(0,16),lwd.ticks=0,labels=F)
axis(4,pos=16.5,at=c(4,14),lwd.ticks=0,labels=F)
par(las = 0)
mtext("S", side = 1, line = 2.5, cex = 1.5, at = 5)
mtext(expression(paste(Delta,"F",sep="")), side = 2, line = 2.8, cex = 1.5,at=9)
#lines(c(1, ntime), c(0, 0), lwd = 1, lty = 2, col = "black")


so2<-sort(S[which((S>0.37) & (S<20))])

num2<-length(so2)

print(c(so2[num2*0.025],so2[num2/3],so2[num2/2],so2[num2*2/3],so2[num2*0.975]))


#now plot the marginals on each axis

rden<-density(arr2[,2],from=4,to=14,bw=0.1)
sden<-density(arr2[,1],bw=0.1)

scale<-20
lines(scale*rden$y+16.5,rden$x,lwd=3)
lines(sden$x,scale*sden$y+14.5,lwd=3)

segments(5,4,5,17,lwd=2,lty=2)
segments(0.6,4,0.6,17,lwd=2,lty=2)
segments(0,9,20.5,9,lwd=2,lty=2)

par(op)

dev.off()



