#calculations and graphs for the implicit prior paper

#paleo fig1

#fix bandwidth for all kernel density estimation 
bww <- 0.05

#values for temp obs likelihood
DT_o <- 5.
DT_sd <- 1.5


#values for forcing prior
DF_o <- 9
DF_sd <- 2

#large sample for smooth results
num <- 10000000

#direct sampling with likelihood weighting

#uniform in lambda

lambda_samp<-runif(num,min=0.37,max=10)
forc_samp<-rnorm(num,mean=DF_o,sd=DF_sd)
sens_samp<-3.7/lambda_samp


#use the model to calculate the temp change.

dt_samp<-forc_samp/lambda_samp

#likelihood weighting

wt <- dnorm(DT_o,mean=dt_samp,sd=DT_sd)

#generating prior density in sensitivity for plotting purposes
sden<-density(sens_samp,from=0,to=10,bw=bww)

#weighted resampling to generate posterior: probability of sampling is 
#proportional to weight

wt=wt/max(wt)

rr <- runif(num)

post<-which(wt>rr)

#generating prior density in sensitivity for plotting purposes
pden<-density(sens_samp[post],from=0,to=10,bw=bww)

#percentiles in the posterior

order <- sort(sens_samp[post])
size <- length(post)

print(c(order[0.05*size],order[0.5*size],order[0.95*size]))


#repeat the above for a uniform prior in sensitivity

sens_samp<-runif(num,min=0.37,max=10)
lambda_samp=3.7/sens_samp

dt_samp<-forc_samp/lambda_samp

wt2 <- dnorm(DT_o,mean=dt_samp,sd=DT_sd)

lden<-density(sens_samp,from=0,to=10,bw=bww)

wt2=wt2/max(wt2)

rr <- runif(num)

lpost<-which(wt2>rr)

lpden<-density(sens_samp[lpost],from=0,to=10,bw=bww)

order <- sort(sens_samp[lpost])
size <- length(lpost)

print(c(order[0.05*size],order[0.5*size],order[0.95*size]))


#cauchy prior in sensitivity

#use square and root to ensure positive half only
sens_samp<-sqrt(rcauchy(num,scale = 5)^2)
lambda_samp=3.7/sens_samp

dt_samp<-forc_samp/lambda_samp

wt3 <- dnorm(DT_o,mean=dt_samp,sd=DT_sd)

cden<-density(sens_samp,from=0,to=10,bw=bww)

wt3=wt3/max(wt3)

rr <- runif(num)

cpost<-which(wt3>rr)

cpden<-density(sens_samp[cpost],from=0,to=10,bw=bww)

order <- sort(sens_samp[cpost])
size <- length(cpost)

print(c(order[0.05*size],order[0.5*size],order[0.95*size]))


#now the method of "sampling the pdfs" assuming the temp obs defines a posterior gaussian pdf.

dt<-rnorm(num,mean=DT_o,sd=DT_sd)
df<-rnorm(num,mean=DF_o,sd=DF_sd)
sn<-3.7*dt/df

snden<- density(sn,from=0,to=10,bw=bww)

so<-sort(sn)
print(c(so[num/20],so[num/2],so[num*19/20]))


pdf("fig1.pdf",width=10,height=10)

op <- par(cex.main = 1.5, mar = c(5, 6, 4, 5) + 0.1, mgp = c(3.5, 1, 0), cex.lab = 1.5,
    font.lab = 2, cex.axis = 1.3, bty = "n", las = 1)


plot(sden,ty='l',col='blue',lwd=3,lty=2,main="Priors and posteriors for Bayesian estimate\n using paleoclimate data",xlab="Sensitivity",ylab="Density")

points(pden,ty='l',col='blue',lwd=3)

points(snden,ty='l',col='cyan',lwd=10)

points(lden,ty='l',col='red',lwd=3,lty=2)

points(lpden,ty='l',col='red',lwd=3)

points(cden,ty='l',col='magenta',lwd=3,lty=2)

points(cpden,ty='l',col='magenta',lwd=3)

par(op)

dev.off()




